;;;; FILE parenscript-series-via-common-lisp-to-js.lisp

(cl:in-package #:parenscript-series)

(declaim (inline ps*-series))
(defun ps*-series (series-expression)
  (parenscript:ps* (series-expand series-expression)))
(declaim (notinline ps*-series))

(defmacro ps-series (series-expression)
  `(parenscript:ps ,(series-expand series-expression)))

(defun gensymsn (sym)
  (gensym (symbol-name sym)))

#+()
(defun eq-series-cl (symbol)
  (multiple-value-bind
        (cl-sym clp)
      (find-symbol (symbol-name symbol) :cl)
    (multiple-value-bind
          (series-sym seriesp)
        (find-symbol (symbol-name symbol) :series)
      (and clp
           seriesp
           (eq cl-sym series-sym)))))


;;(eq 'series::car 'cl:car) ; => T
;;(eq 'series::defun 'cl:defun) ; => NIL

;;; Use (defpsmacro ...) to forcefully inline expansions.
;;(parenscript:defpsmacro cons)
;;(parenscript:defpsmacro car)
;;(parenscript:defpsmacro first)
;;(parenscript:defpsmacro cdr)
;;(parenscript:defpsmacro rest)
;;(parenscript:defpsmacro nth)
;; ;;(cl:elt '(1 2 3) 1) ; valid JavaScript
;; ;;(cl:aref '(1 2 3) 1) ; valid JavaScript
;;(parenscript:defpsmacro row-major-aref)
;;(parenscript:defpsmacro make-sequence)
;;(parenscript:defpsmacro the)
;; ;;(cl:length '(1 2 3)) ; valid JavaScript
;; ;;(cl:list 1 2 3) ; valid JavaScript
;; ;;(cl:listp '(1 2 3)) ; valid JavaScript
;;(parenscript:defpsmacro endp)
;;(parenscript:defpsmacro subseq)
;;(parenscript:defpsmacro series::defun)
;;(parenscript:defpsmacro series::let)


(parenscript:defpsmacro car (list)
  `(elt ,list 1))

(parenscript:defpsmacro first (list)
  `(elt ,list 1))

#|
https://www.w3schools.com/jsref/jsref_slice_array.asp
|#
(parenscript:defpsmacro cdr (list)
  ;; gensyms
  (let
      ((list-gs (gensymsn 'list-)))
    ;; once-only
    `(parenscript:let
         ((,list-gs ,list))
       (parenscript:chain ,list-gs
                          (slice 1 (length ,list-gs))))))

#|
https://www.w3schools.com/jsref/jsref_slice_array.asp
|#
(parenscript:defpsmacro rest (list)
  ;; gensyms
  (let
      ((list-gs (gensymsn 'list-)))
    ;; once-only
    `(parenscript:let
         ((,list-gs ,list))
       (parenscript:chain ,list-gs
                          (slice 1 (length ,list-gs))))))

(parenscript:defpsmacro endp (proper-list)
  `(= (length ,proper-list) 0))

#|
Adding to front of array via splicing to avoid side-effect:
https://stackoverflow.com/questions/8159524/javascript-pushing-element-at-the-beginning-of-an-array

Using concat()
https://stackoverflow.com/questions/8073673/how-can-i-add-new-array-elements-at-the-beginning-of-an-array-in-javascript
https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/concat
https://www.w3schools.com/jsref/jsref_concat_array.asp
https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array

Detecting the version of the ECMA Script standard:
https://stackoverflow.com/questions/47374678/how-to-detect-ecmascript-version
|#
(parenscript:defpsmacro cons (obj1 obj2)
  ;; gensyms
  (let
      ((obj1-gs (gensymsn 'obj1-))
       (obj2-gs (gensymsn 'obj2-)))
    ;; once-only
    `(parenscript:let
         ((,obj1-gs ,obj1) 
          (,obj2-gs ,obj2))
       (cond
         ((eq ,obj2-gs nil)
          (list ,obj1-gs))
         ((not (listp ,obj2-gs))
          (parenscript:chain (list ,obj1-gs)
			     (concat ,obj2-gs)))
         ((and (listp ,obj2-gs)
	       (= (length ,obj2-gs) 1))
          (if (eq (elt ,obj2-gs 0)
		  nil)
              (list ,obj1-gs)
	      (parenscript:chain (list ,obj1-gs)
				 (concat ,obj2-gs))))
         (T
          #|
          (and (listp ,obj2-gs)
	       (> (length ,obj2-gs) 1))
          |#
          (parenscript:chain (list ,obj1-gs)
				 (concat ,obj2-gs)))))))

;;;; END OF FILE parenscript-series-via-common-lisp-to-js.lisp
