;;;; FILE parenscript-series.lisp

(cl:in-package #:parenscript-series)

(declaim (inline ps*-series))
(defun ps*-series (series-expression)
  (parenscript:ps* (series-expand series-expression)))
(declaim (notinline ps*-series))

(defmacro ps-series (series-expression)
  `(parenscript:ps ,(series-expand series-expression)))

(defun gensymsn (sym)
  (gensym (symbol-name sym)))



;;; Custom JavaScript focused scanners


;; Use (series:producing ...) instead of (series:scan-fn ...)
;;  to avoid problems compiling (cl:the ...) and other forms
;;  that series produces in an effort to efficient compile
;;  Common Lisp forms.  ParenScript does *not* support all
;;  of these forms yet.  It seems simpler to reimplement
;;  the roughly 50 series functions from Waters (1989a) in
;;  a JavaScript friendly way rather than porting about
;;  a third of Common Lisps reserved symbols in a ParenScript
;;  friendly way.  Note, that some of Waters's series convenience
;;  functions are specified as a combination of other series
;;  functions.  In these cases the implementation work has
;;  already been done.

(defmacro scan-js-array (arr)
  ;; gensyms
  (let ((arr-gs (gensymsn 'arr-))
        (len-gs (gensymsn 'len-))
        (producing-array-gs (gensymsn 'producing-array-))
        (idx-gs (gensymsn 'idx-)))
    ;; once-only
    `(series::let ((,arr-gs ,arr))
       (series:producing
           (items)
	   ((,producing-array-gs ,arr-gs)
            (,len-gs (parenscript:chain ,arr-gs length))
	    (,idx-gs -1))
	 (loop
           (tagbody
             (incf ,idx-gs)
             (when (= ,idx-gs ,len-gs)
	       (series:terminate-producing))
             (series:next-out items
			      (parenscript:getprop ,producing-array-gs
			                           ,idx-gs))))))))

(defmacro scan-js-array-reverse (arr)
  ;; gensyms
  (let ((arr-gs (gensymsn 'arr-))
        (producing-array-gs (gensymsn 'producing-array-))
        (idx-gs (gensymsn 'idx-)))
    ;; once-only
    `(series::let ((,arr-gs ,arr))
       (series:producing
           (items)
	   ((,producing-array-gs ,arr-gs)
	    (,idx-gs (parenscript:chain ,arr-gs length)))
	 (loop
           (tagbody
             ;; (decf ,idx-gs) gets macroexpanded badly
	     ;;  for ParenScript on SBCL 2.2.11.
             (setf ,idx-gs (1- ,idx-gs))
             (when (= ,idx-gs -1)
	       (series:terminate-producing))
             (series:next-out items
			      (parenscript:getprop ,producing-array-gs
			                           ,idx-gs))))))))



;;; Custom JavaScript focused collectors

(defmacro collect-js-array-push (items)
  ;; gensyms
  (let ((items-gs (gensymsn 'items-))
        (collection-arr-gs (gensymsn 'collection-arr-))
	(elem-gs (gensymsn 'elem-)))
    ;; once-only
    `(series::let ((,items-gs ,items))
       (series:collect-fn T
                          (lambda ()
			    (parenscript:new (-array)))
			  (lambda (,collection-arr-gs ,elem-gs)
			    ;; (series-expand ...) erroneously tries to
			    ;;  expand (cl:push ...) in the form
			    ;;  (push ,elem-gs) .
			    ;;
			    ;; Workaround:     
			    #+()
			    (parenscript:chain ,collection-arr-gs
			                       (push ,elem-gs))
			    (parenscript::funcall
			     (parenscript:getprop ,collection-arr-gs
						  'push)
			      ,elem-gs)
			    ,collection-arr-gs)
                          ,items-gs))))

(defmacro collect-js-array-unshift (items)
  ;; gensyms
  (let ((items-gs (gensymsn 'items-))
        (collection-arr-gs (gensymsn 'collection-arr-))
	(elem-gs (gensymsn 'elem-)))
    ;; once-only
    `(series::let ((,items-gs ,items))
       (series:collect-fn T
                          (lambda ()
			    (parenscript:new (-array)))
			  (lambda (,collection-arr-gs ,elem-gs)
			    (parenscript:chain ,collection-arr-gs
					       (unshift ,elem-gs))
			    ,collection-arr-gs)
                          ,items-gs))))

;;;; END OF FILE parenscript-tagbody-go.lisp
