(require #:parenscript-series)

(defpackage #:parenscript-series-tests
  (:use #:cl #:parenscript-series))

(ps*-series
  '(collect (map-fn T #'1+ (scan '(1 2 3)))))

(ps*-series
  '(collect (map-fn T #'1+ (scan #(1 2 3)))))

(ps*-series
  '(collect 'list (map-fn T #'1+ (scan '(1 2 3)))))

;; SERIES goes straight to output list.  No intermediate lists produced.
(ps*-series
  '(collect 'list (map-fn T #'1+ (scan #(1 2 3)))))

;; Happens to reverse elements.  Probably consing onto front.
(ps*-series
  '(collect 'series::bag (map-fn T #'1+ (scan '(1 2 3)))))

;; SERIES produces an intermediate list.
(ps*-series
  '(collect 'vector (map-fn T #'1+ (scan #(1 2 3)))))

;; SERIES goes straight to the vector. No intermediate list produced.
(ps*-series
  '(collect '(vector * 3) (map-fn T #'1+ (scan #(1 2 3)))))

;; SERIES produces an intermediate list.
(ps*-series
  '(collect '(vector integer *) (map-fn T #'1+ (scan #(1 2 3)))))

;; SERIES goes straight to the vector. No intermediate list produced.
(ps*-series
  '(collect '(vector integer 3) (map-fn T #'1+ (scan #(1 2 3)))))

;; SERIES produces an intermediate list.
(ps*-series
  '(collect '(simple-array integer *) (map-fn T #'1+ (scan #(1 2 3)))))

;; SERIES goes straight to the vector. No intermediate list produced.
(ps*-series
  '(collect '(simple-array integer 3) (map-fn T #'1+ (scan #(1 2 3)))))



;;; Test cases from Waters (1989a)

;;; Test cases from Waters (1989b)
