(require #:parenscript-tagbody-go)

(defpackage #:parenscript-tagbody-go-tests
  (:use #:cl #:parenscript-tagbody-go))


;;; Testing (with-tagbody-helpers ...)
(with-tagbody-helpers
  (and (go-tag-p 'foo)
       (go-tag-p 'bar)
       (go-tag-p 3)
       (go-tag-p -9)

       (not (go-tag-p 1.3))

       (equal
	 (tb-go-tags
	   (rest '(tagbody
		    (preamble-1-1)
		    (preamble-1-2)
		   tag1
		    (foo)
		   tag2
		    (bar))))
         '(tag1 tag2))

       (eq
	 (first-go-tag
	   (rest '(tagbody
		    (preamble-1-1)
		    (preamble-1-2)
		   tag1
		    (foo)
		   tag2
		    (bar))))
         'tag1)

	 (multiple-value-bind (preamble grouping)
	     (split-and-group-tb-body
	       (rest '(tagbody
		        (preamble-1-1)
		        (preamble-1-2)
		       tag1
		        (foo)
		       tag2
		        (bar))))
           (and
	     (equal preamble
		    '((preamble-1-1)
		      (preamble-1-2)))
	     (equal grouping
		    '((tag1 (foo))
		      (tag2 (bar))))))))



;;; Testing (with-tagbody-parenscript-helpers ...)
(with-tagbody-parenscript-helpers
(and
(let ((switch-1-var '#:switch-1-var)
  (inner-block-1-var '#:inner-block-1-var)
  (outer-block-1-var '#:outer-block-1-var))

(equal
(new-go-bindings switch-1-var
		 inner-block-1-var
		 ;; TODO 2023-01-21:  Update to go-tag-info structs
		 '(tb-1-tag1 tb-1-tag2))
;; alist
`((tb-1-tag1 (setf ,switch-1-var 'tb-1-tag1)
	     (return-from ,inner-block-1-var))
  (tb-1-tag2 (setf ,switch-1-var 'tb-1-tag2)
	     (return-from ,inner-block-1-var))))

(equal
(grouping-to-case-forms
  '((tag1 (foo) (tagbody tb-2-tag-1) (hoge))
    (tag2 (bar)))
  ;; TODO 2023-01-21: Update for new-case-counter.
  `((tb-1-tag1 (setf ,switch-1-var 'tb-1-tag1)
	       (return-from ,inner-block-1-var))
    (tb-1-tag2 (setf ,switch-1-var 'tb-1-tag2)
	       (return-from ,inner-block-1-var))))
`((CASE TAG1
    (TAGBODY-RECURSIVE
	(((TB-1-TAG1 (SETF ,SWITCH-1-VAR 'TB-1-TAG1)
		     (RETURN-FROM ,INNER-BLOCK-1-VAR))
	  (TB-1-TAG2 (SETF ,switch-1-var 'TB-1-TAG2)
		     (RETURN-FROM ,inner-block-1-var))))
      (FOO)
      (TAGBODY TB-2-TAG-1)
      (HOGE)))
  (CASE TAG2
    (TAGBODY-RECURSIVE
	(((TB-1-TAG1 (SETF ,SWITCH-1-VAR 'TB-1-TAG1)
		     (RETURN-FROM ,INNER-BLOCK-1-VAR))
	  (TB-1-TAG2 (SETF ,switch-1-var 'TB-1-TAG2)
		     (RETURN-FROM ,inner-block-1-var))))
      (BAR)))))


  (equalp ; Needs #'cl:equalP instead of #'cl:equal.
    (tb-body-to-switch
      outer-block-1-var
      preamble-block-1-var
      inner-block-1-var
      '((preamble-1-1) (preamble-1-2))
      '((tb-1-tag-1 (foo)
		    (tagbody tb-2-tag-1)
		    (tagbody tb-1-tag-1) ; Shadows outer tag!
		    (hoge))
	(tb-1-tag-2 (bar)))
      'tb-1-tag-1
      switch-1-var
      ;; TODO 2023-01-21: Update for new-case-counter.
      `((tb-1-tag-1 (setf ,switch-1-var 'tb-1-tag-1)
		    (return-from ,inner-block-1-var))
	(tb-1-tag-2 (setf ,switch-1-var 'tb-1-tag-2)
		    (return-from ,inner-block-1-var))))

    `(BLOCK ,OUTER-BLOCK-1-VAR
       (LET ((,SWITCH-1-VAR 'TB-1-TAG-1))
	 (BLOCK ,PREAMBLE-BLOCK-1-VAR
	   (PREAMBLE-1-1)
	   (PREAMBLE-1-2))
	 (LOOP DO
	   (BLOCK ,INNER-BLOCK-1-VAR
	     (MACROLET
		 ((GO (GO-TAG)
		    `(PROGN
		       ,@(CDR
			   (ASSOC GO-TAG
				  '((TB-1-TAG-1
				      (SETF ,switch-1-var 'TB-1-TAG-1)
				      (RETURN-FROM ,inner-block-1-var))
				    (TB-1-TAG-2
				      (SETF ,switch-1-var 'TB-1-TAG-2)
				      (RETURN-FROM ,inner-block-1-var))))))))
	       (SWITCH ,switch-1-var
		 (CASE TB-1-TAG-1
		   (TAGBODY-RECURSIVE
		       (((TB-1-TAG-1 (SETF ,switch-1-var 'TB-1-TAG-1)
				     (RETURN-FROM ,inner-block-1-var))
			 (TB-1-TAG-2 (SETF ,switch-1-var 'TB-1-TAG-2)
				     (RETURN-FROM ,inner-block-1-var))))
		     (FOO)
		     (TAGBODY TB-2-TAG-1)
		     (TAGBODY TB-1-TAG-1) ; Shadows outer tag!
		     (HOGE)))
		 (CASE TB-1-TAG-2
		   (TAGBODY-RECURSIVE
		       (((TB-1-TAG-1 (SETF ,switch-1-var 'TB-1-TAG-1)
				     (RETURN-FROM ,inner-block-1-var))
			 (TB-1-TAG-2 (SETF ,switch-1-var 'TB-1-TAG-2)
				     (RETURN-FROM ,inner-block-1-var))))
		     (BAR)))))
	     (RETURN-FROM ,outer-block-1-var)))))))))




(parenscript::ps-macroexpand-1
  '(tagbody a 1 b 2 (go a) c 3))



(parenscript::ps-macroexpand-1
  '(tagbody a 1 b 2 (go a) c 3))

(parenscript::ps*
  '(tagbody a 1 b 2 (go a) c 3))



(parenscript::ps-macroexpand-1
  '(tagbody a 1 b (tagbody x (go c) y (go z) z) 2 (go a) c 3))

(parenscript::ps*
  '(tagbody a 1 b (tagbody x (go c) y (go z) z) 2 (go a) c 3))




(parenscript::ps*
'(tagbody (preamble-1) a 1 b (tagbody x (go c) y (go z) z) 2 (go a) c 3))

(parenscript::ps*
'(tagbody (preamble-1) a 1 b (tagbody (preamble-2) x (go c) y (go z) z) 2 (go a) c 3))



;;; CHECK BUG #1 2023-02-27, reported on parenscript-devel by Jason Miller

(parenscript::ps*
  '(progn
     (cl:defun foo (x) (cl:funcall x))
     (tagbody
       (foo (lambda () (go x)))
       (format t "This does not happen~%")
       x)))

(parenscript::ps*
  '(progn
     (cl:defun foo (x) (cl:funcall x))
     (tagbody
       (foo (lambda () (go x)))
       (format t "This does not happen~%")
       ;; end of preamble
       x
       (foo (lambda () (go end)))
       end)))



;;; CHECK BUG #2 2023-02-27, reported on parenscript-devel by Jason Miller

(parenscript:ps*
  '(defun bar () (tagbody (go x) (alert "hi") x)))


(parenscript:ps*
  '(parenscript:macrolet
     ((rfb3 ()
	    '(return-from bar 3)))
     (cl:defun foo (f) (cl:funcall f))
     (block bar
	    (foo (lambda () (rfb3)))
	    4)))
(parenscript:ps*
  '(progn
     (cl:defun foo (f) (cl:funcall f))
     (block bar
	    (foo (lambda () (return-from bar 3)))
	    4)))


(parenscript:ps*
  '(parenscript:macrolet
     ((go (tag)
	  `(return-from ,tag 3)))
     (cl:defun foo (f) (cl:funcall f))
     (block bar
	    (foo (lambda () (go bar)))
	    4)))

(parenscript:ps*
  '(cl:defun bar ()
     (tagbody
       (go x)
       (alert "hi")
       (tagbody
         (go y)
         (alert "hi2")
         y)
       x)))

(parenscript:ps*                                                                  '(cl:defun bar ()
     (tagbody
       (go x)
       (alert "hi")
       (tagbody
         (go x)
         (alert "hi2")
         x)
       x)))

;; symbol shadowing by inner-most tagbody
(parenscript:ps*
  '(series::defun bar ()
     (tagbody
       (go x)
       (alert "hi")
       (tagbody
         (go x)
         (alert "hi2")
         x)
       x)))


;; shadow many go-tags
(parenscript::ps-macroexpand-1
   '(tagbody
     (go x)
     (alert "hi")
     (tagbody
       (go x)
       (alert "hi2")
       x)
     x))


(parenscript:ps*                                                                  '(cl:defun bar ()
     (tagbody
       (go x)
       (alert "hi")
       (tagbody
         (go x)
         (alert "hi2")
         x)
       x
       (return-from bar 5))))


;; Nested tagbody in preamble
(parenscript:ps*                                                                  '(cl:defun bar ()
     (tagbody
       (tagbody
        (go z)
        (alert "hi")
        z)
       (go x)
       (alert "hi")
       (tagbody
         (go x)
         (alert "hi2")
         x)
       x
       (return-from bar 5))))

;; Nested tagbody in preamble with lots of go-tag shadowing
(parenscript:ps*                                                                  '(cl:defun bar ()
     (tagbody
       (tagbody
        (go x)
        (alert "hi")
        x)
       (go x)
       (alert "hi")
       (tagbody
         (go x)
         (alert "hi2")
         x)
       x
       (return-from bar 5))))
