;;;; FILE series-expand.lisp

(cl:in-package #:series-expand)

(declaim (inline series-expand)) ; save inline expansion

(defun series-expand (series-expression)
    "Like cl:macroexpand for series expressions from
package SERIES.  Remember, that the argument should
likely be quoted.  Furthermore, the series expression
will only be expanded (pipelined) in case the numerous
constraints outlined in Richard C. Waters' two papers [1,2]
are met.

[1] Richard C. Waters (December 1989),
A.I. Memo No. 1082,
Optimization of Series Expressions: Part I: User's
Manual for the Series Macro Package.
URL: <https://dspace.mit.edu/handle/1721.1/6035> .

[2] Richard C. Waters (December 1989),
A.I. Memo No. 1083,
Optimization of Series Expressions: Part II: Overview
of the Theory and Implementation
URL: <https://dspace.mit.edu/handle/1721.1/6031> ."

  (let (series::*renames*
        series::*env*)
    (series::codify
      (series::mergify
        (series::graphify
          series-expression)))))

(declaim (notinline series-expand)) ; only inline upon explicit request

;;;; END FILE series-expand.lisp
